﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class InstitutionMap
    {
        public static async Task<IQueryable<Institution>> MapInstitutions(List<ppms_institution> ppmsInstitutions, string mapRelatedType, PpmsContext context)
        {
            var visns = new List<Institution> { };
            foreach (var ppmsInstitution in ppmsInstitutions)
            {
                var institution = new Institution
                {
                   Name = ppmsInstitution.ppms_name,
                   StationNumber = ppmsInstitution.ppms_stationnumber,
                   StationType = ppmsInstitution.ppms_stationtype
                };

                if (ppmsInstitution.ppms_visn != null)
                    institution.VisnName = ppmsInstitution.ppms_visn.Name;

                if (mapRelatedType.Contains("?$expand=Visn"))
                    mapRelatedType = "Visn";

                //Map Related Types
                switch (mapRelatedType)
                {
                    case "Visn":
                        //Lookup and Map the Single Visn
                        var ppmsVisn =
                            context.va_visnSet.FirstOrDefault(i => i.Id == ppmsInstitution.ppms_visn.Id);
                        var ppmsVisnList = new List<va_visn> { ppmsVisn };
                        institution.Visn =
                            await VisnMap.MapVisns(ppmsVisnList, "None", context);
                        break;
                    default:
                        break;
                }

                visns.Add(institution);
            }
            return visns.AsQueryable();
        }      
    }
}